package gov.va.genisis2.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * The Class StudyApproval.
 * 
 * Description: In this StudyApproval Class implements the interface
 * Serializable and defines the entity and data mapping for the
 * dbo.User_Approver Table in the database.
 */
@Entity
@Table(name = "StudyApproval", schema = "dbo")
public class StudyApproval implements Serializable {
	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = -194113809816029192L;
	
	/** The id. */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	private int id;

	/** The process id. */
	@Column(name = "ProcessId", nullable = false)
	private int processId;

	/** The approval id obtained. */
	@Column(name = "ApprovalIdObtained")
	private String approvalIdObtained;

	/** The associated study approval 1. */
	@Column(name = "AssociatedStudyApproval1")
	private Integer associatedStudyApproval1;

	/** The associated study approval 2. */
	@Column(name = "AssociatedStudyApproval2")
	private Integer associatedStudyApproval2;
	
	/** The associated study approval 3. */
	@Column(name = "AssociatedStudyApproval3")
	private Integer associatedStudyApproval3;
	
	/** The title. */
	@Column(name = "Title", length = 50)
	private String title;
	
	/** The description. */
	@Column(name = "Description", length = 3000)
	private String description;
	
	/** The created on. */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CreatedOn", length = 23)
	private Date createdOn;
	
	/** The modified on. */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "ModifiedOn", length = 23)
	private Date modifiedOn;
	
	/** The created by. */
	@Column(name = "CreatedBy", length = 50)
	private String createdBy;
	
	/** The modified by. */
	@Column(name = "ModifiedBy", length = 50)
	private String modifiedBy;
	
	/** The active. */
	@Column(name = "Active", nullable = false)
	private byte active;
	
	/** The active date. */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "Active_date", nullable = false, length = 23)
	private Date activeDate;
	
	/** The inactive date. */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "Inactive_date", length = 23)
	private Date inactiveDate;
	
	/** The Requests */
	@OneToMany(fetch = FetchType.LAZY, mappedBy = "source")
	private Set<Request> requests = new HashSet<>(0);
	
	

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the new id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the process id.
	 *
	 * @return the process id
	 */
	public int getProcessId() {
		return this.processId;
	}

	/**
	 * Sets the process id.
	 *
	 * @param processId
	 *            the new process id
	 */
	public void setProcessId(int processId) {
		this.processId = processId;
	}

	/**
	 * Gets the approval id obtained.
	 *
	 * @return the approval id obtained
	 */
	public String getApprovalIdObtained() {
		return this.approvalIdObtained;
	}

	/**
	 * Sets the approval id obtained.
	 *
	 * @param approvalIdObtained
	 *            the new approval id obtained
	 */
	public void setApprovalIdObtained(String approvalIdObtained) {
		this.approvalIdObtained = approvalIdObtained;
	}

	/**
	 * Gets the title.
	 *
	 * @return the title
	 */
	public String getTitle() {
		return this.title;
	}

	/**
	 * Sets the title.
	 *
	 * @param title
	 *            the new title
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * Gets the description.
	 *
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description
	 *            the new description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Gets the created on.
	 *
	 * @return the created on
	 */
	public Date getCreatedOn() {
		return this.createdOn;
	}

	/**
	 * Sets the created on.
	 *
	 * @param createdOn
	 *            the new created on
	 */
	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	/**
	 * Gets the modified on.
	 *
	 * @return the modified on
	 */
	public Date getModifiedOn() {
		return this.modifiedOn;
	}

	/**
	 * Sets the modified on.
	 *
	 * @param modifiedOn
	 *            the new modified on
	 */
	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	/**
	 * Gets the created by.
	 *
	 * @return the created by
	 */
	public String getCreatedBy() {
		return this.createdBy;
	}

	/**
	 * Sets the created by.
	 *
	 * @param createdBy
	 *            the new created by
	 */
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * Gets the modified by.
	 *
	 * @return the modified by
	 */
	public String getModifiedBy() {
		return this.modifiedBy;
	}

	/**
	 * Sets the modified by.
	 *
	 * @param modifiedBy
	 *            the new modified by
	 */
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	/**
	 * Gets the associated study approval 1.
	 *
	 * @return the associated study approval 1
	 */
	public Integer getAssociatedStudyApproval1() {
		return this.associatedStudyApproval1;
	}

	/**
	 * Sets the associated study approval 1.
	 *
	 * @param associatedStudyApproval1
	 *            the new associated study approval 1
	 */
	public void setAssociatedStudyApproval1(Integer associatedStudyApproval1) {
		this.associatedStudyApproval1 = associatedStudyApproval1;
	}

	/**
	 * Gets the associated study approval 2.
	 *
	 * @return the associated study approval 2
	 */
	public Integer getAssociatedStudyApproval2() {
		return this.associatedStudyApproval2;
	}

	/**
	 * Sets the associated study approval 2.
	 *
	 * @param associatedStudyApproval2
	 *            the new associated study approval 2
	 */
	public void setAssociatedStudyApproval2(Integer associatedStudyApproval2) {
		this.associatedStudyApproval2 = associatedStudyApproval2;
	}

	/**
	 * Gets the associated study approval 3.
	 *
	 * @return the associated study approval 3
	 */
	public Integer getAssociatedStudyApproval3() {
		return this.associatedStudyApproval3;
	}

	/**
	 * Sets the associated study approval 3.
	 *
	 * @param associatedStudyApproval3
	 *            the new associated study approval 3
	 */
	public void setAssociatedStudyApproval3(Integer associatedStudyApproval3) {
		this.associatedStudyApproval3 = associatedStudyApproval3;
	}

	/**
	 * Gets the requests.
	 *
	 * @return the requests
	 */
	public Set<Request> getRequests() {
		return this.requests;
	}

	/**
	 * Sets the requests
	 *
	 * @param requests
	 *            the requests
	 * 
	 */
	public void setRequests(Set<Request> requests) {
		this.requests = requests;
	}
	
	/**
	 * @return the active
	 */
	public byte getActive() {
		return active;
	}

	/**
	 * @param active the active to set
	 */
	public void setActive(byte active) {
		this.active = active;
	}

	/**
	 * @return the activeDate
	 */
	public Date getActiveDate() {
		return activeDate;
	}

	/**
	 * @param activeDate the activeDate to set
	 */
	public void setActiveDate(Date activeDate) {
		this.activeDate = activeDate;
	}

	/**
	 * @return the inactiveDate
	 */
	public Date getInactiveDate() {
		return inactiveDate;
	}

	/**
	 * @param inactiveDate the inactiveDate to set
	 */
	public void setInactiveDate(Date inactiveDate) {
		this.inactiveDate = inactiveDate;
	}

	

}
